/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.network;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import net.venturecraft.gliders.network.GliderNetwork;
import net.venturecraft.gliders.util.ClientUtil;
import net.venturecraft.gliders.util.GliderUtil;
import org.jetbrains.annotations.NotNull;

public class MessagePlaySound
extends MessageS2C {
    private final ResourceLocation sound;
    private final UUID playerUUID;

    public MessagePlaySound(ResourceLocation sound, UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.sound = sound;
    }

    public MessagePlaySound(FriendlyByteBuf buffer) {
        this.sound = buffer.m_130281_();
        this.playerUUID = buffer.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.sound);
        buffer.m_130077_(this.playerUUID);
    }

    @NotNull
    public MessageType getType() {
        return GliderNetwork.PLAY_SOUND;
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        Player player;
        if (Minecraft.m_91087_().f_91073_ != null && (player = Minecraft.m_91087_().f_91073_.m_46003_(this.playerUUID)) != null) {
            ClientUtil.playGliderSound(player, this.sound, SoundSource.PLAYERS, true, () -> !GliderUtil.isGlidingWithActiveGlider((LivingEntity)player), 0.1f, RandomSource.m_216327_());
        }
    }
}

