/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.toopa.unusualfurniture.UnusualFurnitureMod;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation2Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation3Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation4Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation5Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation6Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation7Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation8Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotationProcedure;
import net.toopa.unusualfurniture.procedures.SetTableRotationItem1Procedure;
import net.toopa.unusualfurniture.world.inventory.TableGUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TableGUISlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;
    private HashMap<String, String> textstate;

    public TableGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta, HashMap<String, String> textstate) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
        this.textstate = textstate;
    }

    public TableGUISlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
        this.textstate = TableGUISlotMessage.readTextState(buffer);
    }

    public static void buffer(TableGUISlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
        TableGUISlotMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(TableGUISlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            TableGUISlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = TableGUIMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            SetTableItemRotationProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 1 && changeType == 0) {
            SetTableRotationItem1Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 2 && changeType == 0) {
            SetTableItemRotation2Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 3 && changeType == 0) {
            SetTableItemRotation3Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 4 && changeType == 0) {
            SetTableItemRotation4Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 5 && changeType == 0) {
            SetTableItemRotation5Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 6 && changeType == 0) {
            SetTableItemRotation6Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 7 && changeType == 0) {
            SetTableItemRotation7Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 8 && changeType == 0) {
            SetTableItemRotation8Procedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        UnusualFurnitureMod.addNetworkMessage(TableGUISlotMessage.class, TableGUISlotMessage::buffer, TableGUISlotMessage::new, TableGUISlotMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

