/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.init;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.toopa.unusualfurniture.UnusualFurnitureMod;
import net.toopa.unusualfurniture.init.UnusualFurnitureModScreens;
import net.toopa.unusualfurniture.world.inventory.CoffeeTableGUIMenu;
import net.toopa.unusualfurniture.world.inventory.DrawerGUIMenu;
import net.toopa.unusualfurniture.world.inventory.TableGUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UnusualFurnitureModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"unusual_furniture");
    public static final RegistryObject<MenuType<TableGUIMenu>> TABLE_GUI = REGISTRY.register("table_gui", () -> IForgeMenuType.create(TableGUIMenu::new));
    public static final RegistryObject<MenuType<CoffeeTableGUIMenu>> COFFEE_TABLE_GUI = REGISTRY.register("coffee_table_gui", () -> IForgeMenuType.create(CoffeeTableGUIMenu::new));
    public static final RegistryObject<MenuType<DrawerGUIMenu>> DRAWER_GUI = REGISTRY.register("drawer_gui", () -> IForgeMenuType.create(DrawerGUIMenu::new));

    public static void setText(String boxname, String value, @Nullable ServerPlayer player) {
        if (player != null) {
            UnusualFurnitureMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GuiSyncMessage(boxname, value));
        } else {
            UnusualFurnitureMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new GuiSyncMessage(boxname, value));
        }
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        UnusualFurnitureMod.addNetworkMessage(GuiSyncMessage.class, GuiSyncMessage::buffer, GuiSyncMessage::new, GuiSyncMessage::handleData);
    }

    public static class GuiSyncMessage {
        private final String textboxid;
        private final String data;

        public GuiSyncMessage(FriendlyByteBuf buffer) {
            this.textboxid = buffer.m_130238_().getString();
            this.data = buffer.m_130238_().getString();
        }

        public GuiSyncMessage(String textboxid, String data) {
            this.textboxid = textboxid;
            this.data = data;
        }

        public static void buffer(GuiSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130083_((Component)Component.m_237113_((String)message.textboxid));
            buffer.m_130083_((Component)Component.m_237113_((String)message.data));
        }

        public static void handleData(GuiSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    UnusualFurnitureModScreens.handleTextBoxMessage(message);
                }
            });
            context.setPacketHandled(true);
        }

        String editbox() {
            return this.textboxid;
        }

        String value() {
            return this.data;
        }
    }
}

